Option Explicit
Const scriptName = "Font Info"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - MJM - Inital version.



' Script constants, questions, and error messages.
Const errNoSelection = "This script requires a text selection."
Const errFontNotFound = "Unable to find the font of the text selection."
Const errNotAvailable = "Not available."
Const errFontFile = "Font files not available."

Const qFindInExplorer = "Find this font's files in Explorer?"
Const cExplorerPrefix = "explorer /select,"""
Const cExplorerSuffix = """"

Const cFontInfoPrefix = "Font Info for "
Const cFontInfoSuffix = ":"
Const cType = "Type: "
Const cFamily = "Family: "
Const cStyle = "Style: "

Const cMoreInfoPrefix = "More Info for "
Const cPSName = "PostScript Name: "
Const cUniqueName = "Unique Name: "

Const cEvenMoreInfoPrefix = "Even More Info for "
Const cCopyright = "Copyright Text: "

Const cTrueType = "TrueType"
Const cType1 = "Type 1"
Const cMissing = "Missing Font"
Const cUnknownType = "Unknown Type"

' Enums

' enum crFontTypes
Const crTrueTypeFont = 0
Const crType1Font = 1
Const crMissingFont = 2
Const crUnknownFont = 3





'Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim TextSel, theFont
If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errNoSelection, vbOkonly, scriptName)
  errNum = -1
End If

If errNum = 0 Then
  On Error Resume Next
  Set TextSel = CreatorApp.TextSelection
  errNum = Err.Number
  On Error GoTo 0
  
  If errNum <> 0 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
  Elseif TextSel.CharacterRuns.Count < 1 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  Elseif TextSel.Start > TextSel.End Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  End If
End If

If errNum = 0 Then
  Err.Clear
  On Error Resume Next
  Set theFont = TextSel.CharacterRuns(1).Font
  errNum = Err.Number
  On Error Goto 0

  If errNum <> 0 Then
    Call MsgBox(errFontNotFound, vbOKOnly, scriptName)
  End If
End If
  


If errNum = 0 Then
  ' Gather Font Data	
  Dim fontName, psName, familyName
  Dim styleName, uniqueName, fullName
  Dim copyright, fontType

  On Error Resume Next
  
  fontName = theFont.Name
  If (Err.Number > 0) Then
    fontName = errNotAvailable
    Err.Clear
  End If
  If (Len(fontName) = 0) Then
    fontName = errNotAvailable
  End If
  
  psName = theFont.PostScriptName
  If (Err.Number > 0) Then
    psName = errNotAvailable
    Err.Clear
  End If 
  If (Len(psName) = 0) Then
    psName = errNotAvailable
  End If

  familyName = theFont.FamilyName
  If (Err.Number > 0) Then
    familyName = errNotAvailable
    Err.Clear
  End If 
  If (Len(familyName) = 0) Then
    familyName = errNotAvailable
  End If

  styleName = theFont.StyleName
  If (Err.Number > 0) Then
    styleName = errNotAvailable
    Err.Clear
  End If 
  If (Len(styleName) = 0) Then
    styleName = errNotAvailable
  End If

  uniqueName = theFont.UniqueName
  If (Err.Number > 0) Then
    uniqueName = errNotAvailable
    Err.Clear
  End If 
  If (Len(uniqueName) = 0) Then
    uniqueName = errNotAvailable
  End If

  fullName = theFont.FullName
  If (Err.Number > 0) Then
    fullName = errNotAvailable
    Err.Clear
  End If 
  If (Len(fullName) = 0) Then
    fullName = errNotAvailable
  End If

  copyright = theFont.Copyright
  If (Err.Number > 0) Then
    copyright = errNotAvailable
    Err.Clear
  End If 
  If (Len(copyright) = 0) Then
    copyright = errNotAvailable
  End If

  fontType = theFont.FontType
  If (Err.Number > 0) Then
    fontType = crUnknownFont
    Err.Clear
  End If
  
  On Error Goto 0

  Dim info1, info2, info3

  info1 = cFontInfoPrefix & fontName & cFontInfoSuffix & vbCRLF & vbCRLF
  info1 = info1 & cType
  If fontType = crUnknownFont Then
    info1 = info1 & cUnknownType
  Elseif fontType = crTrueTypeFont Then
    info1 = info1 & cTrueType
  Elseif fontType = crType1Font Then
    info1 = info1 & cType1
  Elseif fontType = crMissingFont Then
    info1 = info1 & cMissingFont
  Else
    info1 = info1 &  cUnknownType
  End If

  info1 = info1 & vbCRLF
  info1 = info1 & cFamily & familyName & vbCRLF
  info1 = info1 & cStyle & styleName


  info2 = cMoreInfoPrefix & fontName & cFontInfoSuffix & vbCRLF & vbCRLF
  info2 = info2 & cPSName & psName & vbCRLF
  info2 = info2 & cUniqueName & uniqueName

  info3 = cEvenMoreInfoPrefix & fontName & cFontInfoSuffix & vbCRLF & vbCRLF
  info3 = info3 & cCopyright & copyright

  Dim answer
  answer = MsgBox(info1, vbOKCancel, scriptName)
  If (answer = vbOK) Then
    answer = MsgBox(info2, vbOKCancel, scriptName)
  End If

  If (answer = vbOK) Then
    answer = MsgBox(info3, vbOKCancel, scriptName)
  End If

  If (answer = vbOK) Then
    answer = MsgBox(qFindInExplorer, vbYesNo, scriptName)
    If (answer = vbYes) Then
      Err.Clear
      On Error Resume Next
        Dim fontFiles
	fontFiles = theFont.FontFiles
	If Err.Number = 0 Then
	  Dim aFile
	  aFile = fontFiles(LBound(fontFiles))
	  If Err.Number = 0 Then
	    aFile = cExplorerPrefix & aFile & cExplorerSuffix
	    Dim shell
	    Set shell = WScript.CreateObject("WScript.Shell")
	    If Err.Number = 0 Then
              Call shell.Run(aFile, 1, False)
	    End If
	  End If
	End If
	errNum = Err.Number
      On Error Goto 0
      If (errNum <> 0) Then
        Call MsgBox(errFontFile, vbOKOnly, scriptName)
      End If
    End If
  End If	  
End If

